local base = _G

module('cdu_wind')

local type          = base.type
local require       = base.require
local print         = base.print
local assert        = base.assert
local tostring      = base.tostring
local pairs         = base.pairs
local ipairs        = base.ipairs
local tonumber      = base.tonumber
local table         = base.table
local math          = base.math
local string        = base.string
local clock         = base.os.clock

local gettext       = require('i_18n')
local dllWeather 	= require('Weather')
local minizip       = require('minizip')

function toDegrees(radians, raw)
  local degrees = radians * 180 / math.pi
  
  if not raw then
    degrees = math.floor(degrees + 0.5)
  end
  
  return degrees
end

function toPositiveDegrees(radians, raw)
  local degrees = toDegrees(radians, raw)
  
  if degrees < 0 then
    degrees = degrees + 360
  end
  
  return degrees
end

function cduWindToStr(wind, temperature)
	local speed = math.floor(wind.speed*1.94384 + 0.5)
	local angle = wind.dir + 173
	if angle >= 360 then
		angle = angle - 360
	end
    local str = string.format("%.3d/%.2d  %+.2d", angle, speed, temperature)
    return str
end

function cduWindString(a_weather, a_humanPosition, temperature)
    local wind = {}
    if a_weather.atmosphere_type == 0 then
        local w = a_weather.wind        
        wind[1] = '00  ' .. cduWindToStr(w.atGround, temperature)
		local interpolatedWind = {speed = w.atGround.speed*2, dir = w.atGround.dir}
		wind[2] = '02  ' .. cduWindToStr(interpolatedWind, temperature-4)
        wind[3] = '07  ' .. cduWindToStr(w.at2000, temperature-14)
        wind[4] = '26  ' .. cduWindToStr(w.at8000, temperature-52)
    else
        local position = a_humanPosition or {x=0, y=0, z=0}               
    
        local param = {cyclones = a_weather.cyclones, position = position}
        local res = dllWeather.getGroundWindAtPoint(param)
      --  param.agl = 1000
      --  local res = dllWeather.getWindAtPoint(param)
        
        wind[1] = '00  ' .. cduWindToStr({speed=res.v, dir = toPositiveDegrees(res.a+math.pi)}, temperature) 
    end
    return wind
end